// UhfDll.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include <stdio.h>
#include "Serial.h"
#include "UhfDll.h"

#define STX						0x03
#define ADDR					0xAA
#define BUFFER_SIZE				256
#define MS_TIMEOUT				500

#define CMD_CALL_ANTENNAPOWER				0x01
#define CMD_CALL_SENDFIRMWARE_HARDWAREID	0x02
#define CMD_CALL_INVENTORYRSSI				0x05
#define CMD_CALL_SELECTTAG					0x06
#define CMD_CALL_WRITETOTAG					0x07
#define CMD_CALL_READFROMTAG				0x09
#define CMD_CALL_CONFIGRFPOWER				0x16
#define CMD_CALL_SETSENSITIVITY				0x1F

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call) {
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
	}
	return TRUE;
}

UINT8 CRC(UINT8 *buf, UINT32 StartPos, UINT32 size)
{
	UINT8 crc = buf[StartPos];
	
	for (UINT32 i = StartPos + 1; i < size - 1; i++) {
		crc ^= buf[i];
	}
	return crc;
}

void WriteData(UINT8 addr, UINT8 cmd, UINT8 *indata, UINT8 inlen)
{
	UINT8 sendData[BUFFER_SIZE];

	memset(sendData, 0, sizeof(sendData));
	sendData[0] = STX;
	sendData[1] = addr;
	sendData[2] = inlen + 5;
	sendData[3] = cmd;
	if (inlen > 0 && indata != NULL) {
		memcpy(&sendData[4], indata, inlen);
	}
	sendData[4 + inlen] = CRC(sendData, 0, inlen + 5);
	RFID_RadioWrite(RadioHandle, sendData, inlen + 5);
}

BOOL CommunicationData(UINT8 addr, UINT8 cmd, UINT8 *indata, UINT8 inlen, UINT8 *outdata, UINT8 *outlen, UINT32 msTimeout)
{
	int	recvLen;
	UINT8 recvData[BUFFER_SIZE];
	
	WriteData(addr, cmd, indata, inlen);
	memset(recvData, 0, sizeof(recvData));
	recvLen = RFID_RadioRead(RadioHandle, recvData, sizeof(recvData), msTimeout);
	if (recvLen >= 5) {
		if (CRC(recvData, 0, recvData[2]) != recvData[recvData[2] - 1]) {
			return FALSE;
		} else {
			*outlen = recvData[2] - 5;
			if (*outlen > 0) {
				memcpy(outdata, &recvData[4], *outlen);
			}
			return TRUE;
		}
	} else {
		return FALSE;
	}
}

void ProcessInventory(void (CALLBACK *callBack)(TagDataStructType *))
{
	UINT8 packetHand[4];
	UINT8 recvData[TAG_DATA_SIZE];
	TagDataStructType mTag;

	while (1) {
		if (RFID_RadioRead(RadioHandle, packetHand, sizeof(packetHand), 1000) <= 0) {
			return;
		}
		if (packetHand[0] != 0x02 && packetHand[3] != 0x06) {
			continue;
		}
		if (RFID_RadioRead(RadioHandle, &recvData[4], packetHand[2] - 4, 1000) < 8) {
			return;
		}
		memcpy(recvData, packetHand, 4);
		if (CRC(recvData, 0, recvData[2]) != recvData[recvData[2] - 1]) {
			continue;
		}

		mTag.rssi = recvData[5];
		mTag.freq = recvData[6] | (recvData[7] << 8) | (recvData[8] << 16);
		mTag.dataLen = recvData[9];
		memcpy(mTag.data, &recvData[10], mTag.dataLen);
		callBack(&mTag);
	}
}

BOOL UHFDLL_API AS3992_Connect(UINT32 port, ULONG baudrate)
{
	return RFID_RadioOpen(&RadioHandle, port, baudrate, 0);
}

BOOL UHFDLL_API AS3992_Disconnect()
{
	return RFID_RadioClose(RadioHandle);
}

BOOL UHFDLL_API AS3992_CallAntennaPower()
{
	UINT8 indata[] = {0x01};
	UINT8 outdata[1];
	UINT8 outlen;
	return CommunicationData(ADDR, CMD_CALL_ANTENNAPOWER, indata, sizeof(indata), outdata, &outlen, MS_TIMEOUT);
}

void UHFDLL_API AS3992_CallInventoryRSSI_Single(void (CALLBACK *callBack)(TagDataStructType *))
{
	UINT8 indata[] = {0x01, 0x01};
	WriteData(ADDR, CMD_CALL_INVENTORYRSSI, indata, sizeof(indata));
	ProcessInventory(callBack);
}

void UHFDLL_API AS3992_CallInventoryRSSI_Stop(void (CALLBACK *callBack)(TagDataStructType *))
{
	UINT8 indata[] = {0x01, 0x00};
	WriteData(ADDR, CMD_CALL_INVENTORYRSSI, indata, sizeof(indata));
	ProcessInventory(callBack);
}

BOOL UHFDLL_API AS3992_CallSelectTag(UINT8 *epc, UINT8 epclen)
{
	UINT8 inData[BUFFER_SIZE];
	UINT8 outdata[1];
	UINT8 outlen;
	inData[0] = epclen;
	memcpy(&inData[1], epc, epclen);
	if (CommunicationData(ADDR, CMD_CALL_SELECTTAG, inData, epclen + 1, outdata, &outlen, MS_TIMEOUT)) {
		if (outdata[0] == 0x00) {
			return TRUE;
		}
	}
	return FALSE;
}

BOOL UHFDLL_API AS3992_CallWriteTag(UINT8 mem_type, UINT8 addr, UINT8 *password, UINT8 *data, UINT8 datalen, UINT8 *retstatus)
{
	UINT8 indata[BUFFER_SIZE];
	UINT8 outdata[1];
	UINT8 outlen;

	indata[0] = mem_type;
	indata[1] = addr;
	memcpy(&indata[2], password, 4);
	indata[6] = datalen;
	memcpy(&indata[7], data, datalen * 2);
	if (CommunicationData(ADDR, CMD_CALL_WRITETOTAG, indata, datalen * 2 + 7, outdata, &outlen, MS_TIMEOUT)) {
		if (outdata[0] == 0x00) {
			return TRUE;
		} else {
			retstatus[0] = outdata[0];
			return FALSE;
		}
	}

	retstatus[0] = 0x00;
	return FALSE;
}

BOOL UHFDLL_API AS3992_CallReadFromTag(UINT8 mem_type, UINT8 addr, UINT8 datalen, UINT8 *retstatus, UINT8 *retdata, UINT8 *retdatalen)
{
	UINT8 indata[3] = {mem_type, addr, datalen};
	UINT8 outdata[1];
	UINT8 outlen;

	if (CommunicationData(ADDR, CMD_CALL_READFROMTAG, indata, sizeof(indata), outdata, &outlen, MS_TIMEOUT)) {
		if (outdata[0] == 0x00 || outdata[0] == 0x08) {
			retstatus[0] = outdata[0];
			retdatalen[0] = outdata[1];
			memcpy(retdata, &outdata[2], outdata[1] * 2);
			return TRUE;
		} else {
			retstatus[0] = outdata[0];
			return FALSE;
		}
	}
	
	retstatus[0] = 0x00;
	return FALSE;
}

BOOL UHFDLL_API AS3992_CallConfigRFPower(UINT8 attenuation, UINT8 *cur_attenuation)
{
	UINT8 indata[] = {attenuation};
	UINT8 outlen;
	return CommunicationData(ADDR, CMD_CALL_CONFIGRFPOWER, indata, sizeof(indata), cur_attenuation, &outlen, MS_TIMEOUT);
}

BOOL UHFDLL_API AS3992_CallSetSensitivity(UINT8 sensitivity, UINT8 *cur_sensitivity)
{
	UINT8 indata[] = {sensitivity};
	UINT8 outlen;
	return CommunicationData(ADDR, CMD_CALL_SETSENSITIVITY, indata, sizeof(indata), cur_sensitivity, &outlen, MS_TIMEOUT);
}

